string GetDescription()
{
	return "This is an advanced classical piano arrangement. Uses piano ar klavichord timbre.";
}

int ArrangeClassical1(Song @s)
{
	int bars = s.GetBars();
	
	bool organs = false;
	
	if (RndInt(0,1) == 0) // piano timbre
	{
		s.AddTrack("Melody", 2,127,64);
		s.AddTrack("Alt Voice", 1,127,64);
		
		int a1 = RndInt(30,90);
		
		s.AddTrack("Accomp", RndInt(1,2),125,a1);
		s.AddTrack("Bass", RndInt(1,2),127,RndInt(30,90));
		s.AddTrack("Chords", RndInt(1,2),127,RndInt(30,90));
		s.AddTrack("Accomp2", RndInt(1,2),125, 64 + (60-a1));
	}
	else // Hapsichord timbre
	{
		int f,t;
		f = 7;
		t = 8;
		
		s.AddTrack("Melody", RndInt(f,t),127,64);
		s.AddTrack("Alt Voice", RndInt(f,t),127,64);
		
		int a1 = RndInt(30,90);
		
		s.AddTrack("Accomp", RndInt(f,t),125,a1);
		s.AddTrack("Bass", RndInt(f,t),127,RndInt(30,90));
		s.AddTrack("Chords", RndInt(f,t),127,RndInt(30,90));
		s.AddTrack("Accomp2", RndInt(f,t),125, 64 + (60-a1));
	}
	
	int[] seeds(5);
	int[] off(5);
	for (int i = 0; i < seeds.length(); i++)
	{
		seeds[i] = RndInt(0,32000);
		off[i] = RndInt(0,1);
	}
	
	int bass_seed = RndInt(0,32000);
	int bass_seed_chorus = RndInt(0,32000);
	
	string melody = "Simple Melody";
	if (RndInt(0,2) == 0) melody = "Accented Melody";
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0) // no melody
		{
			s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 4,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, 1, CreateTime(0,0),0.7); 		
			s.AddRenderEvent("Arpeggio Chords", seeds[4], 5,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, 1+off[0], CreateTime(0,0),0.7); 
		}	
		else if (s.GetPart(i).GetArrHint() == 1) // main voice
		{
			s.AddRenderEvent(melody, RndInt(0,32000), 0,s.GetPartStartBar(i),s.GetPartEndBar(i), 1, CreateTime(0,0),1); 
			
		}
		else if (s.GetPart(i).GetArrHint() == 2) // alt voice
		{
			s.AddRenderEvent(melody, RndInt(0,32000), 1,s.GetPartStartBar(i),s.GetPartEndBar(i), 1, CreateTime(0,0),1); 
			
		}
		else if (s.GetPart(i).GetArrHint() == 3) // chorus
		{
			s.AddRenderEvent("Chordal Melody", RndInt(0,32000), 0,s.GetPartStartBar(i),s.GetPartEndBar(i), 2+RndInt(0,1), CreateTime(0,0),0.95); 
			s.AddRenderEvent(melody, RndInt(0,32000), 1,s.GetPartStartBar(i),s.GetPartEndBar(i), 1+RndInt(0,1), CreateTime(0,0),1); 
		
			s.AddRenderEvent("Simple Chords", RndInt(0,32000), 4,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, 0, CreateTime(0,0),0.7); 		
			
			s.AddRenderEvent("Arpeggio Chords", RndInt(0,32000), 5,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, 1+off[3], CreateTime(0,0),0.65); 
		
			
		}
		
		s.AddRenderEvent("Arpeggio Chords", seeds[s.GetPart(i).GetArrHint()], 2,s.GetPartStartBar(i),s.GetPartEndBar(i)-1, off[s.GetPart(i).GetArrHint()], CreateTime(0,0),0.7); 
		s.AddRenderEvent("Simple Chords", RndInt(0,32000), 4,s.GetPartEndBar(i)-1,s.GetPartEndBar(i), 1+(seeds[s.GetPart(i).GetArrHint()]%2), CreateTime(0,0),0.8);	
	
		if (s.GetPart(i).GetArrHint() == 3) s.AddRenderEvent("Random Bass ( Extended )", bass_seed_chorus, 3 , s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1.0);	
		else s.AddRenderEvent("Random Bass ( Extended )", bass_seed, 3 , s.GetPartStartBar(i), s.GetPartEndBar(i), RndInt(0,1), CreateTime(0,0),0.9);	
			
	}
	
	if (!organs) s.AddRenderEvent("Simple Chords Smooth", RndInt(0,32000), 2,bars-1,bars, 3, CreateTime(0,s.GetUniquePart(s.GetPart(0).GetUniquePart()).GetMetrum()/2),0.8); 	
	
	
	return 2;
}

void Arrange(Song @s)
{
	int style = RndInt(0,1);
	int slow;
		
	if (style == 0) slow = ArrangeClassical1(s);
	if (style == 1) slow = ArrangeClassical1(s);
		
	if (slow > 0)
	{
		int bars = 0;
		for (int i = 0; i < s.GetParts(); i++)
		{
			double metrum = s.GetUniquePart(s.GetPart(i).GetUniquePart()).GetMetrum();
			bars += s.GetUniquePart(s.GetPart(i).GetUniquePart()).GetBars();
			
			if (i == s.GetParts()-1)
			{
				// zwolnienie na koniec
				s.AddTempoMod(CreateTime(bars-2, metrum/3), 0.95);
				s.AddTempoMod(CreateTime(bars-2, (metrum/3)*2), 0.90);
				s.AddTempoMod(CreateTime(bars-1, 0), 0.8);
			}
			else if (slow > 1)
			{
				// zwolnienie na koniec czesci
				s.AddTempoMod(CreateTime(bars-2, metrum/3), 0.95);
				s.AddTempoMod(CreateTime(bars-2, (metrum/3)*2), 0.90);
				s.AddTempoMod(CreateTime(bars-1, 0), 0.85);
				s.AddTempoMod(CreateTime(bars-1, metrum-1), 0.95);
			}
		}
	}
}